<?php
/**
 * Plugin Name: All in One Video Downloader
 * Version: 2.11.0
 * Plugin URI: https://aiovideodl.ml/
 * Description: All in One Video Downloader
 * Author: Niche Office
 * Author URI: https://support.nicheoffice.web.tr/
 * Requires at least: 5.0
 * Tested up to: 6.2
 *
 * Text Domain: all-in-one-video-downloader
 * Domain Path: /lang/
 *
 * @package WordPress
 * @author Niche Office
 * @since 1.0.0
 */

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

if (!defined('ABSPATH')) {
    exit;
}

// Load plugin class files.
require_once 'includes/class-all-in-one-video-downloader.php';
require_once 'includes/class-all-in-one-video-downloader-settings.php';

// Load plugin libraries.
require_once 'includes/lib/class-all-in-one-video-downloader-admin-api.php';
require_once 'includes/lib/class-all-in-one-video-downloader-post-type.php';
require_once 'includes/lib/class-all-in-one-video-downloader-taxonomy.php';
require_once 'includes/lib/class-all-in-one-video-downloader-downloaders.php';
require_once 'includes/lib/class-all-in-one-video-downloader-routes.php';

// Load plugin updater
require_once 'includes/updater/plugin-update-checker.php';

define('AUTOSAVE_INTERVAL', 300);
define('WP_POST_REVISIONS', false);
define('AIO_VIDEO_DOWNLOADER_VERSION', 'NzM1MjMuNTIyMDIuMjAwMzExLjEwNDYwMA==6');

/**
 * Returns the main instance of All_in_One_Video_Downloader to prevent the need to use globals.
 *
 * @return object All_in_One_Video_Downloader
 * @since  1.0.0
 */
function all_in_one_video_downloader()
{
    $instance = All_in_One_Video_Downloader::instance(__FILE__, '2.11.0');

    if (is_null($instance->settings)) {
        $instance->settings = All_in_One_Video_Downloader_Settings::instance($instance);
    }

    return $instance;
}

function buildUpdateQueries($updateInfo)
{
    if (!empty($updateInfo->download_url)) {
        $updateInfo->download_url = add_query_arg('license_key', get_option('aiodl_license_code'), $updateInfo->download_url);
        $updateInfo->download_url = add_query_arg('url', get_site_url(), $updateInfo->download_url);
        $updateInfo->download_url = add_query_arg('fingerprint', get_option('aiodl_license_fingerprint'), $updateInfo->download_url);
        $updateInfo->download_url = add_query_arg('version', AIO_VIDEO_DOWNLOADER_VERSION, $updateInfo->download_url);
        $updateInfo->download_url = add_query_arg('youtube_enabled', get_option('aiodl_downloader_youtube') == 'on', $updateInfo->download_url);
    }
    return $updateInfo;
}

$updateChecker = PucFactory::buildUpdateChecker(
    'http://api.nicheoffice.web.tr/wp-update-server/metadata/aio-video-downloader.json',
    __FILE__, //Full path to the main plugin file or functions.php.
    'aio-video-downloader',
);

$updateChecker->addFilter('pre_inject_update', 'buildUpdateQueries');

all_in_one_video_downloader();